VERSION 5.00
Begin VB.Form frmGPIBSettings 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "GPIB Settings"
   ClientHeight    =   6255
   ClientLeft      =   2760
   ClientTop       =   3750
   ClientWidth     =   5115
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6255
   ScaleWidth      =   5115
   ShowInTaskbar   =   0   'False
   Begin VB.CommandButton cmdSaveSettings 
      Caption         =   "Save GPIB Settings"
      Height          =   495
      Left            =   2760
      TabIndex        =   13
      Top             =   1200
      Width           =   1215
   End
   Begin VB.Frame fraGPIBCard 
      Caption         =   "GPIB Card"
      Height          =   930
      Left            =   240
      TabIndex        =   12
      Top             =   240
      Width           =   1965
      Begin VB.OptionButton CommOpt 
         Caption         =   "National Instruments"
         Height          =   252
         Index           =   1
         Left            =   72
         TabIndex        =   15
         Top             =   550
         Width           =   1740
      End
      Begin VB.OptionButton CommOpt 
         Caption         =   "Keithley/CEC"
         Height          =   252
         Index           =   0
         Left            =   72
         TabIndex        =   14
         Top             =   240
         Width           =   1620
      End
   End
   Begin VB.Frame fra2510GPIB 
      Caption         =   "2510"
      Height          =   2055
      Left            =   120
      TabIndex        =   5
      Top             =   4080
      Visible         =   0   'False
      Width           =   4455
      Begin VB.TextBox txt2510GPIB 
         Height          =   285
         Left            =   1440
         TabIndex        =   10
         Top             =   360
         Width           =   495
      End
      Begin VB.CommandButton cmd2510IDN 
         Caption         =   "Query ID"
         Height          =   495
         Left            =   2880
         TabIndex        =   9
         Top             =   240
         Width           =   975
      End
      Begin VB.TextBox txt2510Output 
         Height          =   975
         Left            =   120
         Locked          =   -1  'True
         MousePointer    =   1  'Arrow
         MultiLine       =   -1  'True
         OLEDragMode     =   1  'Automatic
         ScrollBars      =   3  'Both
         TabIndex        =   8
         Top             =   960
         Width           =   4215
      End
      Begin VB.Label Label2 
         Caption         =   "GPIB Address"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   360
         Width           =   1095
      End
   End
   Begin VB.Frame fra2520GPIB 
      Caption         =   "2520"
      Height          =   2055
      Left            =   120
      TabIndex        =   2
      Top             =   1800
      Width           =   4455
      Begin VB.TextBox txt2520Output 
         Height          =   975
         Left            =   120
         Locked          =   -1  'True
         MousePointer    =   1  'Arrow
         MultiLine       =   -1  'True
         OLEDragMode     =   1  'Automatic
         ScrollBars      =   3  'Both
         TabIndex        =   7
         Top             =   960
         Width           =   4215
      End
      Begin VB.CommandButton cmd2520IDN 
         Caption         =   "Query ID"
         Height          =   495
         Left            =   2880
         TabIndex        =   6
         Top             =   240
         Width           =   975
      End
      Begin VB.TextBox txt2520GPIB 
         Height          =   285
         Left            =   1560
         TabIndex        =   3
         Top             =   360
         Width           =   495
      End
      Begin VB.Label Label1 
         Caption         =   "GPIB Address"
         Height          =   255
         Left            =   240
         TabIndex        =   4
         Top             =   360
         Width           =   1095
      End
   End
   Begin VB.CommandButton cmdCancelGPIB 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   2760
      TabIndex        =   1
      Top             =   720
      Visible         =   0   'False
      Width           =   1215
   End
   Begin VB.CommandButton cmdOKGPIB 
      Caption         =   "OK"
      Height          =   375
      Left            =   2760
      TabIndex        =   0
      Top             =   240
      Width           =   1215
   End
End
Attribute VB_Name = "frmGPIBSettings"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit
Const BRDNUM = 0                            'NI GPIB Board(controller) Address

Private Sub cmdCancelGPIB_Click()
'Close form without saving (ie, transferring) the latest gpib settings
'to the program variables

frmGPIBSettings.Hide
txt2520Output.Text = ""                 'Reset output window
txt2510Output.Text = ""                 'Reset output window

End Sub

Private Sub cmd2510IDN_Click()
'Initialize 2510 and send an "*IDN?" query, display in txtbox txt2510Output

Dim strID As String * 256
'Dim intNum As ViInt32

'Check GPIB address then assign to variable
If Val(txt2510GPIB.Text) > 30 Or Val(txt2510GPIB.Text) < 0 Then
    MsgBox "GPIB address must be 0-30."
    txt2510GPIB.SetFocus
    Else
    intKI2510 = Val(txt2510GPIB.Text)                   'Copy value into variable

    If SendKI(intKI2510, "*IDN?") Then Exit Sub         'Query ID string

    strID = QueryKI(intKI2510)                          'Retrieve the data
    
'   Parse IDN? output so it fits within the textbox
    txt2510Output.Text = Left(strID, 40) & vbCrLf           '40 characters fit into this textbox
    txt2510Output.Text = txt2510Output.Text & Mid(strID, 41, 40) & vbCrLf
    txt2510Output.Text = txt2510Output.Text & Mid(strID, 81, 40)

'    nErr = Ke2510_init("GPIB0::" & intKI2510 & "::INSTR", VI_ON, handle2510)   'GPIB: Reset 2520 and get handle
'    If nErr <> 0 Then
'        DisplayError handle2510, nErr
'    End If
'
'    nErr = Ke2510_WriteInstrData(handle2510, "*IDN?")   'Send *IDN? query to instrument
'    If nErr <> 0 Then
'        DisplayError handle2510, nErr
'    End If
'
'    nErr = Ke2510_ReadInstrData(handle2510, 100, strID, intNum)    'Read back the ID query results
'    If nErr <> 0 Then
'        DisplayError handle2510, nErr
'    End If
'
'    txt2510Output.Text = strID
'
'    nErr = Ke2510_close(handle2510)
'    If nErr <> 0 Then
'        DisplayError handle2510, nErr
'    End If
'
End If

End Sub

Private Sub cmd2520IDN_Click()
'Initialize 2520 and send an "*IDN?" query, display in txtbox txt2520Output

Dim strID As String * 256
'Dim intNum As ViInt32

'Check GPIB address then assign to variable
If Val(txt2520GPIB.Text) > 30 Or Val(txt2520GPIB.Text) < 0 Then
    MsgBox "GPIB address must be 0-30."
    txt2520GPIB.SetFocus
    Else
    intKI2520 = Val(txt2520GPIB.Text)                   'Copy value into variable

    If SendKI(intKI2520, "*IDN?") Then Exit Sub         'Query ID string

    strID = QueryKI(intKI2520)                          'Retrieve the data
    
'   Parse IDN? output so it fits within the textbox
    txt2520Output.Text = Left(strID, 40) & vbCrLf           '40 characters fit into this textbox
    txt2520Output.Text = txt2520Output.Text & Mid(strID, 41, 40) & vbCrLf
    txt2520Output.Text = txt2520Output.Text & Mid(strID, 81, 40)

'    nErr = Ke2520_init("GPIB0::" & intKI2520 & "::INSTR", VI_ON, handle2520)   'GPIB: Reset 2520 and get handle
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'
'    nErr = Ke2520_WriteInstrData(handle2520, "*IDN?")   'Send *IDN? query to instrument
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'
'    nErr = Ke2520_ReadInstrData(handle2520, 100, strID, intNum)    'Read back the ID query results
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'
'    txt2520Output.Text = strID
'
'    nErr = Ke2520_close(handle2520)
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
   
End If

End Sub

Private Sub cmdSaveSettings_Click()
'Determine card type chosen, then save to a file in same diretory as demo program

'MsgBox "Saving the GPIB card type will prevent you from having to choose the card type every time you use this program."

If CommOpt(0).value Then
    strCard = "CEC"
    Else
    strCard = "NI"
End If

Call StoreSetting(strSetFile)

End Sub

Private Sub CommOpt_Click(Index As Integer)
'Make sure a card is chosen upon program load
'OR that the configuration control file exists
'Also, initialize GPIB card when card choice is made

CheckGPIBCard                               'Enable controls

'Initialize GPIB Card
If CommOpt(0).value Then                          'Keithley/CEC card?
        initialize 21, 0                    'Initialize CEC GPIB controller, GPIB Address=21
        setoutputEOS 10, 0
        setinputEOS 10
        settimeout 10000                    'Set GPIB timeout to 10 s
    Else                                    'Initialize National Instruments Card
        Call SendIFC(BRDNUM)                'Reset GPIB by sending InterFace Clear, forcing card to be Controller-in-Charge of the GPIB
        Call ibtmo(BRDNUM, T10s)            'Set GPIB timeout to 10 s
        Call ibsre(BRDNUM, 1)               'Set the remote enable line
End If

End Sub

Private Sub Form_Load()
'Grab/display values, reset controls

txt2520GPIB.Text = intKI2520            'Copy instrument GPIB address to text window
txt2510GPIB.Text = intKI2510            'Copy instrument GPIB address to text window

Call CheckGPIBCard              'Dis/Enable OK & Cancel buttons

'Set tool tip text for various controls on form
cmdSaveSettings.ToolTipText = "Click here to save the GPIB card and address settings to " & strSetFile & _
                                ", eliminating the need to re-enter this data again."
CommOpt(0).ToolTipText = "Keithley/CEC KPC-488.2 card"
CommOpt(1).ToolTipText = "NI-488.2M card"
cmd2520IDN.ToolTipText = "Checks for proper communication by sending GPIB command ""*IDN?"" to instrument."
cmd2510IDN.ToolTipText = "Checks for proper communication by sending GPIB command ""*IDN?"" to instrument."
fraGPIBCard.ToolTipText = "Please select the GPIB card to use."

End Sub

Private Sub cmdOKGPIB_Click()
'Transfer GPIB address, reset text boxes and close frmGPIBSettings

frmGPIBSettings.Hide
txt2520Output.Text = ""                 'Reset output window
txt2510Output.Text = ""                 'Reset output window
intKI2510 = txt2510GPIB.Text            'Copy GPIB address from txtbox to variable
intKI2520 = txt2520GPIB.Text            'Copy GPIB address from txtbox to variable

End Sub

Public Sub CheckGPIBCard()
'Makes sure that one GPIB card type is chosen
'before enabling the OK, Save Settings, Query ID and Cancel buttons

'If no GPIB card is chosen, disable the OK, cancel and Save buttons
If CommOpt(0).value Or CommOpt(1).value Then    'One card chosen, enable buttons
    cmdOKGPIB.Enabled = True
    cmdCancelGPIB.Enabled = True
    cmdSaveSettings.Enabled = True
    cmd2520IDN.Enabled = True
    cmd2510IDN.Enabled = True
    Else                                        'Neither card chosen
    cmdOKGPIB.Enabled = False
    cmdCancelGPIB.Enabled = False
    cmdSaveSettings.Enabled = False
    cmd2520IDN.Enabled = False
    cmd2510IDN.Enabled = False
End If

End Sub
